<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

/*************************************************************************
Original code and thanks to SK v3 Arcade Member Stats
/SK
*************************************************************************/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'arcadetourmnt');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('v3arcade');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'v3arcade_headinclude',
	'v3arcade_navbar',
	'v3arcade_tournament_navbar'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'fetchtitle' => array(
		'v3arcade_tournament_ajax_edit'
	),
	'none' => array(
		'v3ARCADE_TOURNAMENT',
		'v3arcade_tournamentbits',
		'v3arcade_tournamentbits_none'
	),
	'newtourmnt' => array(
		'v3ARCADE_TOURNAMENT_SUBMITNEW',
		'v3arcade_tournament_submitnew_buddybits'
	),
	'viewtourmnt' => array(
		'v3ARCADE_TOURNAMENT_VIEW',
		'v3arcade_tournament_view_treebit'
	),
	'viewwaiting' => array(
		'v3ARCADE_TOURNAMENT',
		'v3arcade_tournamentbits',
		'v3arcade_tournamentbits_none'
	),
	'viewactive' => array(
		'v3ARCADE_TOURNAMENT',
		'v3arcade_tournamentbits',
		'v3arcade_tournamentbits_none'
	),
	'viewfinished' => array(
		'v3ARCADE_TOURNAMENT',
		'v3arcade_tournamentbits',
		'v3arcade_tournamentbits_none'
	),
	'viewyour' => array(
		'v3ARCADE_TOURNAMENT',
		'v3arcade_tournamentbits',
		'v3arcade_tournamentbits_none'
	)
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/v3arcade_functions.php');
require_once(DIR . '/includes/v3arcade_functions_tourmnt.php');
require_once(DIR . '/includes/functions_user.php');

// Check basic permissions.
if (!$vbulletin->options['tourmnt_enabled'] OR !($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canviewarcade']))
{
	print_no_permission();
}

// If the Arcade is closed and you're not an admin, print the error.
if (!$vbulletin->options['arcadeopen'] AND !($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
{
	standard_error($vbulletin->options['arcadeclosedmessage']);
}

// Add in Arcade user options.
$vbulletin->userinfo = array_merge(
	convert_bits_to_array($vbulletin->userinfo['arcadeoptions'], $vbulletin->bf_misc_arcadeoptions),
	$vbulletin->userinfo
);

// Make sure these phrases don't have quotes
$jsphrase = array(
	'add_favorite' => addcslashes($vbphrase['add_favorite'], '\''),
	'sub_favorite' => addcslashes($vbphrase['sub_favorite'], '\''),
	'are_you_sure' => addcslashes($vbphrase['are_you_sure'], '\''),
	'noresults' => addcslashes($vbphrase['noresults'], '\'')
);

eval('$arcade_headinclude = "' . fetch_template('v3arcade_headinclude') . '";');

// Alternate navbar template.
$navbartemplate = ($vbulletin->options['usealtnav']) ? 'v3arcade_navbar' : 'navbar';

// Alternate opacity for popup menus.
$vbulletin->options['popupopacityalt'] = $vbulletin->options['popupopacity'] / 100;

// Just in case.
$bitfieldcheck = '';

$footer = construct_phrase($vbphrase['arcade_end'], $vbulletin->options['arcadeimages']) . $footer;

eval('$tournaments_navbar = "' . fetch_template('v3arcade_tournament_navbar') . '";');

// set for pages with no tournaments since exec_switch_bg() isn't run there
$bgclass = 'alt1';

($hook = vBulletinHook::fetch_hook('arcadetourmnt_global')) ? eval($hook) : false;

// #############################################################################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = ($vbulletin->userinfo['userid']) ? 'viewactive' : 'viewyour';
}

// #############################################################################
if ($_REQUEST['do'] == 'newtourmnt')
{
	// 'newtourmnt'
	// Create a new tournament.

	$vbulletin->input->clean_gpc('r', 'gameid', TYPE_UINT);

	// Check if user has the rights to create a new tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canstarttourmnt']))
	{
		print_no_permission();
	}

	// This hook is when a user has clicked "Start new tournament".
	($hook = vBulletinHook::fetch_hook('arcadetourmnt_new')) ? eval($hook) : false;

	$gameoptions = '';

	if ($vbulletin->GPC['gameid'])
	{
		// A specific game has ben submitted, get info about that game.
		if (!$game = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "v3arcade_games
			WHERE (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['isactive'] . ")
				AND (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['enablechallenges'] . ")
				AND !(gamepermissions & " . $vbulletin->bf_misc_gamepermissions['disablescoring'] . ")
				AND system IN(0, 10, 99)
				AND gameid = " . $vbulletin->GPC['gameid']
		))
		{
			print_no_permission();
		}
	}
	else
	{
		// Get a list of all games
		$getgames = $db->query_read("
			SELECT gameid, title
			FROM " . TABLE_PREFIX . "v3arcade_games
			WHERE (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['isactive'] . ")
				AND (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['enablechallenges'] . ")
				AND !(gamepermissions & " . $vbulletin->bf_misc_gamepermissions['disablescoring'] . ")
				AND system IN(0, 10, 99)
			ORDER BY title ASC
		");
		while ($games = $db->fetch_array($getgames))
		{
			$gameoptions .= '<option value="' . $games['gameid'] . '">' . $games['title'] . '</option>';
		}
	}

	$defaulttitle = $vbulletin->userinfo['username'] . ' ' . vbdate($vbulletin->options['dateformat'], TIMENOW);

	// Invite Buddies
	$invitebuddies = '';
	if ($vbulletin->userinfo['buddylist'])
	{
		$getbuddies = $db->query_read("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE userid IN(" . str_replace(' ', ', ', $vbulletin->userinfo['buddylist']) . ")
			ORDER BY username
		");
		while ($buddy = $db->fetch_array($getbuddies))
		{
			eval('$invitebuddies .= "' . fetch_template('v3arcade_tournament_submitnew_buddybits') . '";');
		}
	}

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $vbphrase['start_a_new_tournament']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT_SUBMITNEW') . '");');
}

// ###### Do Create New Tournament ############################################
if ($_POST['do'] == 'createtourmnt')
{
	// Check if user has the rights to create a new tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canstarttourmnt']) OR !$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'autojoin' => TYPE_BOOL,
		'description' => TYPE_NOHTML,
		'gameid' => TYPE_UINT,
		'invitebuddy' => TYPE_ARRAY_INT,
		'joincost' => TYPE_UINT,
		'numplayers' => TYPE_UINT,
		'numtries' => TYPE_UINT,
		'title' => TYPE_NOHTML
	));

	if ($vbulletin->GPC['numtries'] < 0 OR $vbulletin->GPC['numtries'] > 3)
	{
		print_no_permission();
	}

	// Check that submitted data is OK
	$rounds = fetch_num_rounds($vbulletin->GPC['numplayers']);
	if (!$rounds)
	{
		print_no_permission();
	}

	$game = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_games
		WHERE gameid = " . $vbulletin->GPC['gameid']
	);

	// Check that the game exists and get all data about it.
	if (!$game['gameid'])
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['game'])));
	}

	// Check if the user is allowed to play this game
	check_canplay($game);

	$title = $vbulletin->GPC['title'];

	if (!$title)
	{
		$title = $vbulletin->userinfo['username'] . ' ' . vbdate($vbulletin->options['dateformat'], TIMENOW);
	}

	if (strlen($title) > 50)
	{
		$title = substr($title, 0, 50);
	}

	$description = $vbulletin->GPC['description'];
	if (strlen($description) > 250)
	{
		$description = substr($description, 0, 250);
	}

	$tournament_joincost = 0;
	if ($vbulletin->options['tourmntEnableCosts'])
	{
		// If join cost enabled set some variables for easy integration.
		$tournament_joinuserid = $vbulletin->userinfo['userid'];
		$tournament_joincost = $vbulletin->GPC['joincost'];
	}

	$openslots = $vbulletin->GPC['numplayers'];
	if ($vbulletin->GPC['autojoin'])
	{
		$openslots -= 1; // One slot automatically filled by the creator
	}

	// This hook is just before the new tournament is added to the database.
	($hook = vBulletinHook::fetch_hook('arcadetourmnt_create')) ? eval($hook) : false;

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_tournaments
			(title, gameid, gametitle, description, creator, datestamp, roundstart, status, numplayers, numtries, openslots, round, joincost)
		VALUES (
			'" . $db->escape_string($title) . "',
			" . $vbulletin->GPC['gameid'] . ",
			'" . $db->escape_string($game['title']) . "',
			'" . $db->escape_string($description) . "',
			" . $vbulletin->userinfo['userid'] . ",
			" . TIMENOW . ",
			0,
			0,
			" . $vbulletin->GPC['numplayers'] . ",
			" . $vbulletin->GPC['numtries'] . ",
			$openslots,
			$rounds,
			$tournament_joincost
	)");
	$tid = $db->insert_id();

	build_tournament_cache();

	// Create all the slots
	if ($vbulletin->GPC['autojoin'])
	{
		$randomslot = rand(0, $vbulletin->GPC['numplayers'] - 1);
	}

	$slots = '';
	for($slotcnt = 0; $slotcnt < $vbulletin->GPC['numplayers']; $slotcnt++)
	{
		if ($vbulletin->GPC['autojoin'] AND $slotcnt == $randomslot)
		{
			$slots .= '(' . $tid . ', ' . $vbulletin->userinfo['userid'] . ', ' . TIMENOW . ", 0, $rounds, $slotcnt), "; // Special for the creator
		}
		else
		{
			$slots .= "($tid, 0, NULL, 0, $rounds, $slotcnt), "; // Empty slot
		}
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_tournamentplayers
			(tid, userid, datestamp, tries, round, slot)
		VALUES
		" . substr($slots, 0, strlen($slots) - 2)
	);

	// Send buddy invites
	send_tournament_invite($vbulletin->GPC['invitebuddy']);

	if ($vbulletin->options['tourmntaddnews'] & $vbulletin->bf_misc_arcadetourmnt_addnews['arcadetourmnt_addnews_create'])
	{
		insert_arcade_news(construct_phrase(
			$vbphrase['news_tournament_created'],
			$title,
			$vbulletin->userinfo['username']
		));
	}

	// Go to the tournament page
	$vbulletin->url = 'arcadetourmnt.php?' .  $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $tid;
	eval(print_standard_redirect('v3_tournament_created'));
}

// #############################################################################
if ($_REQUEST['do'] == 'jointourmnt')
{
	// 'jointourmnt'
	// Join a tournament with the logged in user

	// Check if user has the rights to join a tournament and is not guest
	if (!$vbulletin->userinfo['userid'] OR !($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canjointourmnt']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_gpc('r', 'tid', TYPE_UINT);

	// Get tournament info
	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse, arcade_games.minpoststotal, arcade_games.minpostsperday, arcade_games.minpoststhisday, arcade_games.minreglength, arcade_games.minrep
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid']
	);
	if (!$tournament)
	{
		eval(standard_error(fetch_error($vbphrase['v3_no_tournament_found'])));
	}

	check_canplay($tournament);

	if (!$tournament['a_gametitle'])
	{
		eval(standard_error(fetch_error($vbphrase['v3_game_not_available'])));
	}

	if (!$tournament['openslots'])
	{
		eval(standard_error(fetch_error($vbphrase['v3_no_slots_left'])));
	}

	// Check if user isn't already signed up
	$check = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers
		WHERE tid = " . $vbulletin->GPC['tid'] . "
			AND userid = " . $vbulletin->userinfo['userid']
	);
	if ($check)
	{
		eval(standard_error(fetch_error($vbphrase['v3_already_signed_up'])));
	}

	if ($vbulletin->options['tourmntEnableCosts'])
	{
		// If join cost enabled set some variables for easy integration.
		$tournament_joinuserid = $vbulletin->userinfo['userid'];
		$tournament_joincost = $tournament['joincost'];
	}

	// This hook is just before the new user is added to the tournament database.
	($hook = vBulletinHook::fetch_hook('arcadetourmnt_join')) ? eval($hook) : false;

	// Update a random slot with the userid and date
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
			userid = " . $vbulletin->userinfo['userid'] . ",
			datestamp = " . TIMENOW . "
		WHERE tid = " . $vbulletin->GPC['tid'] . "
			AND round = $tournament[round]
			AND userid = 0
		ORDER BY RAND()
		LIMIT 1
	");

	if ($db->affected_rows())
	{
		// Update tournament info
		$openslots = $tournament['openslots'] - 1;
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournaments SET
				openslots = " . $openslots .
				iif (!$openslots, ', status = 1, roundstart = ' . TIMENOW) . "
			WHERE tid = " . $vbulletin->GPC['tid']
		);

		// update cache if status changed above
		if (!$openslots)
		{
			build_tournament_cache();
		}

		if (!$openslots)
		{
			// This hook is when all slots are filled and the tournament starts
			($hook = vBulletinHook::fetch_hook('arcadetourmnt_start')) ? eval($hook) : false;


			if ($vbulletin->options['tourmntaddnews'] & $vbulletin->bf_misc_arcadetourmnt_addnews['arcadetourmnt_addnews_started'])
			{
				insert_arcade_news(construct_phrase($vbphrase['news_tournament_started'], $tournament['title']));
			}

			// Send messages to the other users that the tournament has started
			// Get a list of the usesr and their options, skip the user that just joined.
			$tplayers = $db->query_read("
				SELECT arcade_tournamentplayers.userid, user.arcadeoptions, user.email, user.username
				FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
				WHERE arcade_tournamentplayers.tid = " . $vbulletin->GPC['tid'] . "
					AND arcade_tournamentplayers.round = $tournament[round]
					AND arcade_tournamentplayers.userid != " . $vbulletin->userinfo['userid']
			);
			if ($db->num_rows($tplayers))
			{
				vbmail_start();
				while ($tp = $db->fetch_array($tplayers))
				{
					if ($tp['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['tournamentsevents'])
					{
						if ($tp['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
						{
							vbmail($tp['email'],
								construct_phrase($vbphrase['tournaments_notification'], $tournament['title']),
								construct_phrase(
									$vbphrase['tournaments_notification_started_email'],
									$tp['username'],
									$tournament['title'],
									$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
									$tournament['username']
								),
								false
							);
						}

						if ($tp['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
						{
							$senderpermissions['adminpermissions'] = 2;

							$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
							$pmdm->set_info('is_automated', true);
							$pmdm->set('fromuserid', $tournament['creator']);
							$pmdm->set('fromusername', $tournament['username']);
							$pmdm->set('title', construct_phrase($vbphrase['tournaments_notification'], $tournament['title']));
							$pmdm->set('message', construct_phrase($vbphrase['tournaments_notification_started_pm'], $tp['username'], $tournament['title'], $vbulletin->options['bburl'] . "/arcadetourmnt.php?do=viewtourmnt&tid=" . $tournament['tid'], $tournament['username']));
							$pmdm->set_recipients($tp['username'], $senderpermissions);
							$pmdm->set('dateline', TIMENOW);

							if (empty($pmdm->errors)) $pmdm->save();
						}
					}
				}
				vbmail_end();
			}
		}
	}

	// Go to the tournament page
	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];

	eval(print_standard_redirect('v3_tournament_signedup'));
}

// #############################################################################
if ($_REQUEST['do'] == 'viewtourmnt')
{
	// 'viewtourmnt'
	// Show tournament tree and general info.

	// Check if user has the rights to view a tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_gpc('r', 'tid', TYPE_UINT);

	// Get tournament info
	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid']
	);
	if (!$tournament['tid'])
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	// Has the user got the rights to admin
	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		// Show admin menu with delete and compare scores.
		$show['adminmenu'] = true;
		$show['deletebtn'] = true;

		// Tournament not finished, show more buttons
		if ($tournament['status'] < 2)
		{
			$show['cmpscoresbtn'] = true;
			$show['disqall'] = true;
			$show['sendreminders'] = true;
		}

		// Tournament not started, allowed to withdraw players
		if (!$tournament['status'])
		{
			$canwithdraw = true;
		}
	}

	// Show admin menu with compare scores if it is the creator and tournament not finished
	if ($vbulletin->userinfo['userid'] == $tournament['creator'] AND $tournament['status'] < 2)
	{
		$show['adminmenu'] = true;
		$show['cmpscoresbtn'] = true;
		$show['disqall'] = true;
		$show['sendreminders'] = true;

		// Tournament not started, allowed to withdraw players
		if (!$tournament['status'])
		{
			$canwithdraw = true;
		}
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_view')) ? eval($hook) : false;

	$resultcache = array();
	$userids = array();

	$tourmntresults = $db->query_read("
		SELECT arcade_tournamentplayers.*, user.username
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
		WHERE tid = " . $vbulletin->GPC['tid'] . "
		ORDER BY datestamp ASC
	");
	if ($tourmntresults)
	{
		while ($row = $db->fetch_array($tourmntresults))
		{
			$resultcache[$row['round']][$row['slot']] = $row;
			$userids[$row['userid']] = $row['userid']; // Get a list of all users in this tournament
		}
	}

	$db->free_result($tourmntresults);

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	if (!$tournament['a_gametitle'])
	{
		$statusphrase = fetch_error($vbphrase['v3_game_not_available']);
	}
	else if (!$tournament['status'])
	{
		$statusphrase = 'waiting_for_players';
	}
	else
	{
		$statusphrase = 'roundstatus_' . $tournament['round'];
	}

	$tournmtstatus = $vbphrase[$statusphrase];

	if ($vbulletin->options['tourmntEnableCosts'])
	{
		if ($tournament['joincost'])
		{
			$tourmntcost = construct_phrase(
				$vbphrase['cost_to_join_x_winner_gets_y'],
				vb_number_format($tournament['joincost']),
				vb_number_format($tournament['joincost'] * $tournament['numplayers'])
			);
		}
		else
		{
			$tourmntcost = $vbphrase['free_tournament'];
		}
	}

	$tournament['created_date'] = vbdate($vbulletin->options['dateformat'], $tournament['datestamp']);
	$highlowphrase = ($tournament['isreverse']) ? $vbphrase['low'] : $vbphrase['high'];

	$show['signuplink'] = ($vbulletin->userinfo['userid'] AND !$tournament['status'] AND !in_array($vbulletin->userinfo['userid'], $userids));

	// Build tree
	$tree = array(
		'2' => array(
			'design' => array(
				'0'  => array( 11, 3, 3,  10),
				'1'  => array(  3, 3, 3,   3),
				'2'  => array(512, 3, 3,   2),
				'3'  => array(  0, 4, 3,   0),
				'4'  => array(  2, 6, 7, 256),
				'5'  => array(  0, 6, 8,   0),
				'6'  => array(513, 5, 3,   2),
				'7'  => array(  0, 3, 3,   0)
			)
		),
		'4' => array(
			'design' => array(
				'0'  => array( 12, 3, 3,  11, 3, 3,  10),
				'1'  => array(  3, 3, 3,   3, 3, 3,   3),
				'2'  => array(768, 3, 3,   2, 3, 3,   2),
				'3'  => array(  0, 4, 3,   0, 3, 3,   0),
				'4'  => array(  2, 6, 7, 512, 3, 3,   2),
				'5'  => array(  0, 6, 8,   0, 4, 3,   0),
				'6'  => array(769, 5, 3,   2, 6, 3,   2),
				'7'  => array(  0, 3, 3,   0, 6, 3,   0),
				'8'  => array(  2, 3, 3,   2, 6, 7, 256),
				'9'  => array(  0, 3, 3,   0, 6, 8,   0),
				'10' => array(770, 3, 3,   2, 6, 3,   2),
				'11' => array(  0, 4, 3,   0, 6, 3,   0),
				'12' => array(  2, 6, 7, 513, 5, 3,   2),
				'13' => array(  0, 6, 8,   0, 3, 3,   0),
				'14' => array(771, 5, 3,   2, 3, 3,   2),
				'15' => array(  0, 3, 3,   0, 3, 3,   0)
			)
		),
		'8' => array(
			'rounds' => '3',
			'design' => array(
				'0'  => array(  13, 3, 3,  12, 3, 3,  11, 3, 3,  10),
				'1'  => array(   3, 3, 3,   3, 3, 3,   3, 3, 3,   3),
				'2'  => array(1024, 3, 3,   2, 3, 3,   2, 3, 3,   2),
				'3'  => array(   0, 4, 3,   0, 3, 3,   0, 3, 3,   0),
				'4'  => array(   2, 6, 7, 768, 3, 3,   2, 3, 3,   2),
				'5'  => array(   0, 6, 8,   0, 4, 3,   0, 3, 3,   0),
				'6'  => array(1025, 5, 3,   2, 6, 3,   2, 3, 3,   2),
				'7'  => array(   0, 3, 3,   0, 6, 3,   0, 3, 3,   0),
				'8'  => array(   2, 3, 3,   2, 6, 7, 512, 3, 3,   2),
				'9'  => array(   0, 3, 3,   0, 6, 8,   0, 4, 3,   0),
				'10' => array(1026, 3, 3,   2, 6, 3,   2, 6, 3,   2),
				'11' => array(   0, 4, 3,   0, 6, 3,   0, 6, 3,   0),
				'12' => array(   2, 6, 7, 769, 5, 3,   2, 6, 3,   2),
				'13' => array(   0, 6, 8,   0, 3, 3,   0, 6, 3,   0),
				'14' => array(1027, 5, 3,   2, 3, 3,   2, 6, 3,   2),
				'15' => array(   0, 3, 3,   0, 3, 3,   0, 6, 3,   0),
				'16' => array(   2, 3, 3,   2, 3, 3,   2, 6, 7, 256),
				'17' => array(   0, 3, 3,   0, 3, 3,   0, 6, 8,   0),
				'18' => array(1028, 3, 3,   2, 3, 3,   2, 6, 3,   2),
				'19' => array(   0, 4, 3,   0, 3, 3,   0, 6, 3,   0),
				'20' => array(   2, 6, 7, 770, 3, 3,   2, 6, 3,   2),
				'21' => array(   0, 6, 8,   0, 4, 3,   0, 6, 3,   0),
				'22' => array(1029, 5, 3,   2, 6, 3,   2, 6, 3,   2),
				'23' => array(   0, 3, 3,   0, 6, 3,   0, 6, 3,   0),
				'24' => array(   2, 3, 3,   2, 6, 7, 513, 5, 3,   2),
				'25' => array(   0, 3, 3,   0, 6, 8,   0, 3, 3,   0),
				'26' => array(1030, 3, 3,   2, 6, 3,   2, 3, 3,   2),
				'27' => array(   0, 4, 3,   0, 6, 3,   0, 3, 3,   0),
				'28' => array(   2, 6, 7, 771, 5, 3,   2, 3, 3,   2),
				'29' => array(   0, 6, 8,   0, 3, 3,   0, 3, 3,   0),
				'30' => array(1031, 5, 3,   2, 3, 3,   2, 3, 3,   2),
				'31' => array(   0, 3, 3,   0, 3, 3,   0, 3, 3,   0)
			)
		),
		'16' => array(
			'rounds' => '4',
			'design' => array(
				'0'  => array(  14, 3, 3,   13, 3, 3,  12, 3, 3,  11, 3, 3,  10),
				'1'  => array(   3, 3, 3,    3, 3, 3,   3, 3, 3,   3, 3, 3,   3),
				'2'  => array(1280, 3, 3,    2, 3, 3,   2, 3, 3,   2, 3, 3,   2),
				'3'  => array(   0, 4, 3,    0, 3, 3,   0, 3, 3,   0, 3, 3,   0),
				'4'  => array(   2, 6, 7, 1024, 3, 3,   2, 3, 3,   2, 3, 3,   2),
				'5'  => array(   0, 6, 8,    0, 4, 3,   0, 3, 3,   0, 3, 3,   0),
				'6'  => array(1281, 5, 3,    2, 6, 3,   2, 3, 3,   2, 3, 3,   2),
				'7'  => array(   0, 3, 3,    0, 6, 3,   0, 3, 3,   0, 3, 3,   0),
				'8'  => array(   2, 3, 3,    2, 6, 7, 768, 3, 3,   2, 3, 3,   2),
				'9'  => array(   0, 3, 3,    0, 6, 8,   0, 4, 3,   0, 3, 3,   0),
				'10' => array(1282, 3, 3,    2, 6, 3,   2, 6, 3,   2, 3, 3,   2),
				'11' => array(   0, 4, 3,    0, 6, 3,   0, 6, 3,   0, 3, 3,   0),
				'12' => array(   2, 6, 7, 1025, 5, 3,   2, 6, 3,   2, 3, 3,   2),
				'13' => array(   0, 6, 8,    0, 3, 3,   0, 6, 3,   0, 3, 3,   0),
				'14' => array(1283, 5, 3,    2, 3, 3,   2, 6, 3,   2, 3, 3,   2),
				'15' => array(   0, 3, 3,    0, 3, 3,   0, 6, 3,   0, 3, 3,   0),
				'16' => array(   2, 3, 3,    2, 3, 3,   2, 6, 7, 512, 3, 3,   2),
				'17' => array(   0, 3, 3,    0, 3, 3,   0, 6, 8,   0, 4, 3,   0),
				'18' => array(1284, 3, 3,    2, 3, 3,   2, 6, 3,   2, 6, 3,   2),
				'19' => array(   0, 4, 3,    0, 3, 3,   0, 6, 3,   0, 6, 3,   0),
				'20' => array(   2, 6, 7, 1026, 3, 3,   2, 6, 3,   2, 6, 3,   2),
				'21' => array(   0, 6, 8,    0, 4, 3,   0, 6, 3,   0, 6, 3,   0),
				'22' => array(1285, 5, 3,    2, 6, 3,   2, 6, 3,   2, 6, 3,   2),
				'23' => array(   0, 3, 3,    0, 6, 3,   0, 6, 3,   0, 6, 3,   0),
				'24' => array(   2, 3, 3,    2, 6, 7, 769, 5, 3,   2, 6, 3,   2),
				'25' => array(   0, 3, 3,    0, 6, 8,   0, 3, 3,   0, 6, 3,   0),
				'26' => array(1286, 3, 3,    2, 6, 3,   2, 3, 3,   2, 6, 3,   2),
				'27' => array(   0, 4, 3,    0, 6, 3,   0, 3, 3,   0, 6, 3,   0),
				'28' => array(   2, 6, 7, 1027, 5, 3,   2, 3, 3,   2, 6, 3,   2),
				'29' => array(   0, 6, 8,    0, 3, 3,   0, 3, 3,   0, 6, 3,   0),
				'30' => array(1287, 5, 3,    2, 3, 3,   2, 3, 3,   2, 6, 3,   2),
				'31' => array(   0, 3, 3,    0, 3, 3,   0, 3, 3,   0, 6, 3,   0),
				'32' => array(   2, 3, 3,    2, 3, 3,   2, 3, 3,   2, 6, 7, 256),
				'33' => array(   0, 3, 3,    0, 3, 3,   0, 3, 3,   0, 6, 8,   0),
				'34' => array(1288, 3, 3,    2, 3, 3,   2, 3, 3,   2, 6, 3,   2),
				'35' => array(   0, 4, 3,    0, 3, 3,   0, 3, 3,   0, 6, 3,   0),
				'36' => array(   2, 6, 7, 1028, 3, 3,   2, 3, 3,   2, 6, 3,   2),
				'37' => array(   0, 6, 8,    0, 4, 3,   0, 3, 3,   0, 6, 3,   0),
				'38' => array(1289, 5, 3,    2, 6, 3,   2, 3, 3,   2, 6, 3,   2),
				'39' => array(   0, 3, 3,    0, 6, 3,   0, 3, 3,   0, 6, 3,   0),
				'40' => array(   2, 3, 3,    2, 6, 7, 770, 3, 3,   2, 6, 3,   2),
				'41' => array(   0, 3, 3,    0, 6, 8,   0, 4, 3,   0, 6, 3,   0),
				'44' => array(1290, 3, 3,    2, 6, 3,   2, 6, 3,   2, 6, 3,   2),
				'45' => array(   0, 4, 3,    0, 6, 3,   0, 6, 3,   0, 6, 3,   0),
				'46' => array(   2, 6, 7, 1029, 5, 3,   2, 6, 3,   2, 6, 3,   2),
				'47' => array(   0, 6, 8,    0, 3, 3,   0, 6, 3,   0, 6, 3,   0),
				'48' => array(1291, 5, 3,    2, 3, 3,   2, 6, 3,   2, 6, 3,   2),
				'49' => array(   0, 3, 3,    0, 3, 3,   0, 6, 3,   0, 6, 3,   0),
				'50' => array(   2, 3, 3,    2, 3, 3,   2, 6, 7, 513, 5, 3,   2),
				'51' => array(   0, 3, 3,    0, 3, 3,   0, 6, 8,   0, 3, 3,   0),
				'52' => array(1292, 3, 3,    2, 3, 3,   2, 6, 3,   2, 3, 3,   2),
				'53' => array(   0, 4, 3,    0, 3, 3,   0, 6, 3,   0, 3, 3,   0),
				'54' => array(   2, 6, 7, 1030, 3, 3,   2, 6, 3,   2, 3, 3,   2),
				'55' => array(   0, 6, 8,    0, 4, 3,   0, 6, 3,   0, 3, 3,   0),
				'56' => array(1293, 5, 3,    2, 6, 3,   2, 6, 3,   2, 3, 3,   2),
				'57' => array(   0, 3, 3,    0, 6, 3,   0, 6, 3,   0, 3, 3,   0),
				'58' => array(   2, 3, 3,    2, 6, 7, 771, 5, 3,   2, 3, 3,   2),
				'59' => array(   0, 3, 3,    0, 6, 8,   0, 3, 3,   0, 3, 3,   0),
				'60' => array(1294, 3, 3,    2, 6, 3,   2, 3, 3,   2, 3, 3,   2),
				'61' => array(   0, 4, 3,    0, 6, 3,   0, 3, 3,   0, 3, 3,   0),
				'62' => array(   2, 6, 7, 1031, 5, 3,   2, 3, 3,   2, 3, 3,   2),
				'63' => array(   0, 6, 8,    0, 3, 3,   0, 3, 3,   0, 3, 3,   0),
				'64' => array(1295, 5, 3,    2, 3, 3,   2, 3, 3,   2, 3, 3,   2),
				'65' => array(   0, 3, 3,    0, 3, 3,   0, 3, 3,   0, 3, 3,   0)
			)
		)
	);

	$tourmnttree = '<table width="' . $treesize[$tournament['numplayers']]['total'] . '" border="0" cellspacing="0" cellpadding="0">';

	foreach($tree[$tournament['numplayers']]['design'] as $row )
	{
		$tourmnttree .= '<tr>';

		foreach($row as $coltype)
		{
			if ($coltype >= 256)
			{
				($hook = vBulletinHook::fetch_hook('arcadetourmnt_tree')) ? eval($hook) : false;

				$tourmnttree .= '<td rowspan="2" style="border: solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">';
				$slot = $coltype & 255;
				$round = ($coltype >> 8) - 1;

				$roundcache =& $resultcache[$round][$slot];

				$slotbit['loser'] = false;
				$slotbit['winner'] = false;
				$slotbit['active'] = false;
				$slotbit['disqualify'] = false;
				$slotbit['notified'] = false;
				$slotbit['lastactivity'] = false;
				$slotbit['userid'] = $roundcache['userid'];
				$reminderdate = '';

				if (!isset($roundcache['userid']))
				{
					$slotbit['type'] = 0; // Slot not set, waiting for results from earlier rounds.
				}
				else
				{
					if ($roundcache['userid'] == 0)
					{
						$slotbit['type'] = 1; // slot set but no player yet. Only in first round when all slots not filled.
					}
					else
					{
						$slotbit['gamelink'] = '';
						$slotbit['date'] = vbdate($vbulletin->options['dateformat'], $roundcache['datestamp']);
						$slotbit['time'] = vbdate($vbulletin->options['timeformat'], $roundcache['datestamp']);

						if ($roundcache['status'] == 30)
						{
							// It's a champion!
							$slotbit['type'] = 3;

							// Get the player's avatar URL.
							$avatarurl = fetch_avatar_url($roundcache['userid']);
							$slotbit['avatarsize'] = $avatarurl[1];
							$slotbit['avatarurl'] = $avatarurl[0];
							if (!$avatarurl)
							{
								$slotbit['avatarurl'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
							}
						}
						else
						{
							$slotbit['type'] = 2; // Slot set with a player.

							// Is the player playing right now?
							if ($roundcache['playing'])
							{
								$slotbit['playing'] = $vbphrase['playing_now'];

								if ($vbulletin->userinfo['userid'] == $roundcache['userid']
									OR ($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt'])
									OR $vbulletin->userinfo['userid'] == $tournament['creator']
								)
								{
									// If it is the actual user or someone with admin rights also show a 'clear playing flag' link.
									// Just in case something goes wrong :P
									$slotbit['gamelink'] = '<a href="#" onMouseDown="clearplaying(' . $roundcache['tpid']. ' ,  ' . $roundcache['tid'] . ')">' . $vbphrase['reset_playing_flag'] . '</a>';
								}
							}
							else
							{
								// Tournament hasn't started and user can withdraw
								if (!$tournament['status'] AND ($canwithdraw OR $vbulletin->userinfo['userid'] == $slotbit['userid']))
								{
									$slotbit['gamelink'] = '<a href="#" onclick="withdrawplayer(' . $slotbit['userid']. ', ' . $roundcache['tid'] . ')">' . $vbphrase['withdraw'] . '</a>';
								}

								$slotbit['playing'] = '';
							}

							if ($roundcache['status'] < 10)
							{
								// No winner/loser decided yet
								$slotbit['active'] = true;

								// Construct user info
								$slotbit['userinfo'] = construct_phrase(
									$vbphrase['played_x_y'],
									$roundcache['tries'],
									$tournament['numtries']
								);

								// Check if last activity should be marked
								$lastactivityphrase = 'last_activity_x_at_y';

								if ($roundcache['tries'] < $tournament['numtries'] AND $tournament['status'] == 1 AND $round == $tournament['round'])
								{
									if ($roundcache['notified'])
									{
										$reminderdate = $roundcache['notified'];
									}
									else
									{
										$reminderdate = ($tournament['roundstart'] > $roundcache['datestamp']) ? $tournament['roundstart'] : $roundcache['datestamp'];
									}

									$reminderdate += $vbulletin->options['tourmntReminderTime'] * 3600;

									if (TIMENOW > $reminderdate AND $tournament['status'])
									{
										$lastactivityphrase .= '_marked';
									}
								}

								$slotbit['lastactivity'] = construct_phrase(
									$vbphrase[$lastactivityphrase],
									vbdate($vbulletin->options['dateformat'], $roundcache['datestamp'], true),
									vbdate($vbulletin->options['timeformat'], $roundcache['datestamp'])
								);

								// If already been notified, show date when that happened. Only if the user hasn't had any activity since then.
								if ($roundcache['notified'] AND $roundcache['notified'] > $roundcache['datestamp'])
								{
									$slotbit['notified'] = construct_phrase(
										$vbphrase['reminder_send_x_at_y'],
										vbdate($vbulletin->options['dateformat'], $roundcache['notified'], true),
										vbdate($vbulletin->options['timeformat'], $roundcache['notified'])
									);
								}

								// If its the logged in user, show the score and a play link if not all attempts is done.
								if ($roundcache['userid'] == $vbulletin->userinfo['userid'])
								{
									$slotbit['score'] = construct_phrase(
										$vbphrase['score_x'],
										iif(isset($roundcache['score']), v3_score_format($roundcache['score']),
										$vbphrase['n_a'])
									);

									if ($roundcache['tries'] < $tournament['numtries'] AND $tournament['status'] == 1 AND !$slotbit['playing'] AND $round == $tournament['round'])
									{
										$slotbit['gamelink'] = '<a href="arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=play&amp;gameid=' . $tournament['gameid'] . '&tid=' . $vbulletin->GPC['tid'] . '">' . $vbphrase['play_now'] . '</a>';
									}
								}
								else
								{
									// Hide scores (or not) for all other users.
									if ($vbulletin->options['tourmntHideScores'])
									{
										$slotbit['score'] = $vbphrase['score_hidden'];
									}
									else
									{
										$slotbit['score'] = construct_phrase(
											$vbphrase['score_x'],
											(isset($roundcache['score']) ? v3_score_format($roundcache['score']) : $vbphrase['n_a'])
										);
									}
								}

								// Create a disqualify link if it's the creator or someone with admin rights
								if ($show['disqall'])
								{
									$slotbit['disqualify'] = true;
								}
							}
							else
							{
								// A result has been set, check if its a winner or a looser.
								if ($roundcache['status'] >= 10 AND $roundcache['status'] < 20)
								{
									$slotbit['loser'] = true;
								}
								else
								{
									$slotbit['winner'] = true;
								}

								if ($roundcache['status'] == 11)
								{
									$slotbit['score'] = $vbphrase['disqualified'];
								}
								else
								{
									$slotbit['score'] = construct_phrase(
										$vbphrase['score_x'],
										(isset($roundcache['score']) ? v3_score_format($roundcache['score']) : $vbphrase['n_a'])
									);
								}

								$slotbit['userinfo'] = construct_phrase(
									$vbphrase['played_x_y'],
									$roundcache['tries'],
									$tournament['numtries']
								) . '<br /><br />' . construct_phrase(
									$vbphrase['completed_x_at_y'],
									vbdate($vbulletin->options['dateformat'], $roundcache['datestamp']),
									vbdate($vbulletin->options['timeformat'], $roundcache['datestamp'])
								);

								$slotbit['lastactivity'] = '';
							}
						}
					}
				}

				eval('$tourmnttree .= "' . fetch_template('v3arcade_tournament_view_treebit') . '";');
				$tourmnttree .= '</td>';
			}
			else
			{
				switch($coltype)
				{
					case 2:
						$tourmnttree .= '<td rowspan="2">&nbsp;</td>';
					break;
					case 3:
						$tourmnttree .= '<td>&nbsp;</td>';
					break;
					case 4:
						$tourmnttree .= '<td style="border-top:solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '; border-' . $stylevar['right'] . ':solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">&nbsp;</td>';
					break;
					case 5:
						$tourmnttree .= '<td style="border-bottom:solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '; border-' . $stylevar['right'] . ':solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">&nbsp;</td>';
					break;
					case 6:
						$tourmnttree .= '<td style="border-' . $stylevar['right'] . ':solid 2px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">&nbsp;</td>';
					break;
					case 7:
						$tourmnttree .= '<td style="border-bottom:solid 1px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">&nbsp;</td>';
					break;
					case 8:
						$tourmnttree .= '<td style="border-top:solid 1px ' . $vbulletin->options['tourmntTreeBorderColor'] . '">&nbsp;</td>';
					break;
					case 10:
						$tourmnttree .= '<td align="center"><div class="smallfont"><strong>' . $vbphrase['champion'] . '</strong></div></td>';
					break;
					case 11:
						$tourmnttree .= '<td align="center"><div class="smallfont"><strong>' . $vbphrase['roundstatus_1'] . '</strong></div></td>';
					break;
					case 12:
						$tourmnttree .= '<td align="center"><div class="smallfont"><strong>' . $vbphrase['roundstatus_2'] . '</strong></div></td>';
					break;
					case 13:
						$tourmnttree .= '<td align="center"><div class="smallfont"><strong>' . $vbphrase['roundstatus_3'] . '</strong></div></td>';
					break;
					case 14:
						$tourmnttree .= '<td align="center"><div class="smallfont"><strong>' . $vbphrase['roundstatus_4'] . '</strong></div></td>';
					break;
				}
			}
		}

		$tourmnttree .= '</tr>';
	}

	$tourmnttree .= '</table>';

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $tournament['title']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT_VIEW') . '");');
}

// #############################################################################
if ($_REQUEST['do'] == 'viewwaiting')
{
	// Check if user has the rights to view a tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		print_no_permission();
	}

	// 'viewactive'
	// Show a list of tournaments that waits for players
	$vbulletin->input->clean_gpc('r', 'show', TYPE_STRING);

	$waitinglist = '';
	$signeduplist = array();

	// Are the user allowed to join tournaments?
	$canjoin = (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canjointourmnt']) AND $vbulletin->userinfo['userid']);

	// If user is allowed to join, get list of tournaments that user is active in.
	if ($canjoin)
	{
		$tourmntresults = $db->query_read("
			SELECT arcade_tournamentplayers.tid, arcade_tournamentplayers.status
			FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
			WHERE arcade_tournamentplayers.userid = " . $vbulletin->userinfo['userid'] . "
				AND arcade_tournaments.status = 0
			GROUP BY arcade_tournamentplayers.tid
		");
		if ($tourmntresults)
		{
			while ($tourmntinfo = $db->fetch_array($tourmntresults))
			{
				$signeduplist[$tourmntinfo['tid']] = $tourmntinfo['status'];
			}
		}
	}

	$show['awaiting'] = true;
	$show['tourtype'] = 'awaiting';

	// Are the user allowed to edit and delete tournaments?
	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		$show['editbutton'] = true;
		$show['deletebutton'] = true;
	}

	// Get list of tournaments
	$tourmntresults = $db->query_read("
		SELECT arcade_tournaments.*, user.username AS creatorname, arcade_games.title AS a_gametitle, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE status = 0
		ORDER BY arcade_tournaments.datestamp DESC
	");
	if ($db->num_rows($tourmntresults))
	{
		while ($tourmntinfo = $db->fetch_array($tourmntresults))
		{
			if ($tourmntinfo['a_gametitle'])
			{
				$tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle'];
			}

			if ($tourmntinfo['joincost'])
			{
				$tourmntinfo['joincost_format'] = vb_number_format($tourmntinfo['joincost']);
			}
			else
			{
				$tourmntinfo['joincost_format'] = $vbphrase['free'];
			}

			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);

			$showrow = false;
			if (!$canjoin)
			{
				$tourmntinfo['signuplink'] = $vbphrase['not_allowed_to_join'];
			}
			else
			{
				if (!isset($signeduplist[$tourmntinfo['tid']]))
				{
					$tourmntinfo['signuplink'] = '<a href="arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=jointourmnt&amp;tid=' . $tourmntinfo['tid'] . '">' . $vbphrase['signup'] . '</a>';
				}
				else
				{
					if ($signeduplist[$tourmntinfo['tid']] == 40)
					{
						$tourmntinfo['signuplink'] = $vbphrase['withdrawn'];
					}
					else
					{
						$showrow = true;
						$tourmntinfo['signuplink'] = $vbphrase['signed_up'];
					}
				}
			}

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			if ($vbulletin->GPC['show'] != 'in' OR $showrow)
			{
				// If show is set to 'in' only show row if the user is signed up to the tournament.
				exec_switch_bg();
				eval('$waitinglist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
			}
		}
	}
	else
	{
		$nonecolspan = ($vbulletin->options['tourmntEnableCosts']) ? 7 : 6;
		eval('$waitinglist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	$db->free_result($tourmntresults);

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $vbphrase['tournaments_awaiting_players']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT') . '");');
}

// #############################################################################
if ($_REQUEST['do'] == 'viewactive')
{
	// 'viewactive'
	// Show a list of tournaments that are active

	// Check if user has the rights to view a tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		print_no_permission();
	}

	$activelist = "";

	$show['active'] = true;
	$show['tourtype'] = 'active';

	// Are the user allowed to edit and delete tournaments?
	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		$show['editbutton'] = true;
		$show['deletebutton'] = true;
	}

	// Get list of tournaments
	$tourmntresults = $db->query_read("
		SELECT arcade_tournaments.*, user.username AS creatorname, arcade_games.title AS a_gametitle, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE status = 1
		ORDER BY arcade_tournaments.datestamp DESC
	");
	if ($db->num_rows($tourmntresults))
	{
		$show['pstatus'] = false;
		while ($tourmntinfo = $db->fetch_array($tourmntresults))
		{
			// Use the arcade gametitle if there is any.
			if ($tourmntinfo['a_gametitle'])
			{
				$tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle'];
			}
			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);
			$tourmntinfo['round']	= $vbphrase['roundstatus_' . $tourmntinfo['round']];

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			exec_switch_bg();
			eval('$activelist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
		}
	}
	else
	{
		$nonecolspan = 5;
		eval('$activelist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	$db->free_result($tourmntresults);

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $vbphrase['active_tournaments']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT') . '");');
}

// #############################################################################
if ($_REQUEST['do'] == 'viewfinished')
{
	// 'viewfinished'
	// Show a list of tournaments that are finished
	$vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);

	// Check if user has the rights to view a tournament
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		print_no_permission();
	}

	$page = $vbulletin->GPC['page'];
	$perpage = $vbulletin->options['tourmntFTPerPage'];
	$finishedlist = '';

	$show['finished'] = true;
	$show['tourtype'] = 'finished';

	// Are the user allowed to edit and delete tournaments?
	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		$show['editbutton'] = true;
		$show['deletebutton'] = true;
	}

	// Get total number of tournaments
	$countquery = $db->query_first("
		SELECT COUNT(*) AS totalcount
		FROM " . TABLE_PREFIX . "v3arcade_tournaments
		WHERE status = 2
	");

	$tourncount = intval($countquery['totalcount']);

	sanitize_pageresults(
		$tourncount,
		$page,
		$perpage,
		$vbulletin->options['tourmntFTPerPage'],
		$vbulletin->options['tourmntFTPerPage']
	);

	$querystart = intval(($perpage * $page) - $perpage);

	$pagenav = construct_page_nav(
		$page,
		$perpage,
		$tourncount,
		'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewfinished'
	);

	// Get list of tournaments
	$tourmntresults = $db->query_read("
		SELECT arcade_tournaments.*, user1.username AS creatorname, user2.username AS winnername, arcade_games.title AS a_gametitle, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user1 ON (user1.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON (user2.userid = arcade_tournaments.winner)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE status = 2
		ORDER BY arcade_tournaments.datestamp
		DESC LIMIT $querystart, $perpage
	");
	if ($db->num_rows($tourmntresults))
	{
		while ($tourmntinfo = $db->fetch_array($tourmntresults))
		{
			// Use the arcade gametitle if there is any.
			if ($tourmntinfo['a_gametitle'])
			{
				$tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle'];
			}

			if ($tourmntinfo['joincost'])
			{
				$tourmntinfo['prize'] = vb_number_format($tourmntinfo['joincost'] * $tourmntinfo['numplayers']);
			}
			else
			{
				$tourmntinfo['prize'] = $vbphrase['none'];
			}
			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			exec_switch_bg();
			eval('$finishedlist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
		}
	}
	else
	{
		$nonecolspan = ($vbulletin->options['tourmntEnableCosts']) ? 6 : 5;
		eval('$finishedlist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	$db->free_result($tourmntresults);

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $vbphrase['finished_tournaments']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT') . '");');
}

// #############################################################################
if ($_REQUEST['do'] == 'viewyour')
{
	// 'viewyour'
	// Show a list of tournaments that a user is or has been active in
	$vbulletin->input->clean_array_gpc('r', array(
		'u' => TYPE_UINT,
		'page' => TYPE_UINT
	));

	if (!$vbulletin->GPC['u'])
	{
		$vbulletin->GPC['u'] = $vbulletin->userinfo['userid'];
	}

	// Check if user has the rights to view a tournament
	if (!$vbulletin->GPC['u'] OR !($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		print_no_permission();
	}

	$waitinglist = '';
	$activelist = '';
	$finishedlist = '';

	// Are the user allowed to edit and delete tournaments?
	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		$show['editbutton'] = true;
		$show['deletebutton'] = true;
	}

	$show['active'] = true;
	$show['awaiting'] = true;
	$show['finished'] = true;

	$show['tourtype'] = 'active';

	// Get active tournaments, and work the result to see if we are still in or eliminated
  $tourmntresults = $db->query_read("
  	SELECT arcade_tournamentplayers.status AS pstatus, arcade_tournamentplayers.tries, arcade_tournamentplayers.round AS pround, arcade_tournaments.*, user1.username AS creatorname, arcade_games.title AS a_gametitle, stdimage
  	FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments  AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user1 ON (user1.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE arcade_tournamentplayers.userid = " . $vbulletin->GPC['u'] . "
			AND arcade_tournamentplayers.status < 40
			AND ((arcade_tournamentplayers.round = arcade_tournaments.round)
				OR (arcade_tournamentplayers.status >= 10 AND arcade_tournamentplayers.status < 20)
			)
			AND arcade_tournaments.status = 1
		ORDER BY arcade_tournaments.datestamp DESC
	");
	if ($db->num_rows($tourmntresults))
	{
		$activetourmnts = array();

		while ($row = $db->fetch_array($tourmntresults))
		{
			$activetourmnts[$row['tid']] = $row;

			if ($row['pstatus'] >= 10 AND $row['pstatus'] < 20)
			{
				$activetourmnts[$row['tid']]['pstatus'] = $vbphrase['eliminated'];
			}
			else
			{
				$activetourmnts[$row['tid']]['pstatus'] = construct_phrase($vbphrase['alive_x_y'], $row['tries'], $row['numtries']);
			}
		}

		$db->free_result($tourmntresults);

		$show['pstatus'] = true;
		$activelist = "";
		foreach($activetourmnts as $tourmntinfo)
		{
			// Use the arcade gametitle if there is any.
			if ($tourmntinfo['a_gametitle'])
			{
				$tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle'];
			}
			$tourmntinfo['round']	= $vbphrase['roundstatus_' . $tourmntinfo['round']];
			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			exec_switch_bg(2);
			eval('$activelist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
		}
	}
	else
	{
		$nonecolspan = 5;
		eval('$activelist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	$show['tourtype'] = 'awaiting';
	// Get tournaments awaiting players
	$tourmntresults = $db->query_read("
		SELECT arcade_tournamentplayers.status AS pstatus, arcade_tournaments.*, user1.username AS creatorname, user2.username AS winnername, arcade_games.title AS a_gametitle, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user1 ON (user1.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON (user2.userid = arcade_tournaments.winner)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE arcade_tournamentplayers.userid = " . $vbulletin->GPC['u'] . "
			AND arcade_tournamentplayers.status < 40
			AND arcade_tournaments.status = 0
		GROUP BY arcade_tournamentplayers.tid
		ORDER BY arcade_tournaments.datestamp DESC
	");
	if ($db->num_rows($tourmntresults))
	{
		while ($tourmntinfo = $db->fetch_array($tourmntresults))
		{
			// Use the arcade gametitle if there is any.
			if ($tourmntinfo['a_gametitle'])
			{
				$tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle'];
			}

			if ($tourmntinfo['joincost'])
			{
				$tourmntinfo['joincost_format'] = vb_number_format($tourmntinfo['joincost']);
				$tourmntinfo['prize'] = vb_number_format($tourmntinfo['joincost'] * $tourmntinfo['numplayers']);
			}
			else
			{
				$tourmntinfo['prize'] = $vbphrase['none'];
				$tourmntinfo['joincost_format'] = $vbphrase['free'];
			}

			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);
		  $tourmntinfo['signuplink'] = $vbphrase['signed_up'];

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			exec_switch_bg(1);
			eval('$waitinglist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
		}
	}
	else
	{
		$nonecolspan = ($vbulletin->options['tourmntEnableCosts']) ? 7 : 6;
		eval('$waitinglist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	// Get finished tournaments
	$page = $vbulletin->GPC['page'];
	$perpage = $vbulletin->options['tourmntFTPerPage'];

	// Get total number of finished tournaments
	$countquery = $db->query_first("
		SELECT COUNT(*) AS totalcount
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
		WHERE arcade_tournamentplayers.userid = " . $vbulletin->GPC['u'] . "
			AND arcade_tournaments.status = 2
			AND (arcade_tournamentplayers.status = 30
				OR (arcade_tournamentplayers.status >= 10 AND arcade_tournamentplayers.status < 20)
			)
	");

	$tourncount = intval($countquery['totalcount']);

	sanitize_pageresults(
		$tourncount,
		$page,
		$perpage,
		$vbulletin->options['tourmntFTPerPage'],
		$vbulletin->options['tourmntFTPerPage']
	);

	$querystart = intval($perpage * $page) - $perpage;

	$pagenav = construct_page_nav(
		$page,
		$perpage,
		$tourncount,
		'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewyour'
	);

	$show['tourtype'] = 'finished';

	$tourmntresults = $db->query_read("
		SELECT arcade_tournamentplayers.status AS pstatus, arcade_tournaments.*, user1.username AS creatorname, user2.username AS winnername, arcade_games.title AS a_gametitle, stdimage
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user1 ON (user1.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2 ON (user2.userid = arcade_tournaments.winner)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE arcade_tournamentplayers.userid = " . $vbulletin->GPC['u'] . "
			AND arcade_tournamentplayers.status < 40
			AND arcade_tournaments.status = 2
		GROUP BY arcade_tournamentplayers.tid
		ORDER BY arcade_tournaments.datestamp DESC
		LIMIT $querystart, $perpage
	");
	if ($db->num_rows($tourmntresults))
	{
		while ($tourmntinfo = $db->fetch_array($tourmntresults))
		{
			if ($tourmntinfo['a_gametitle']) $tourmntinfo['gametitle'] = $tourmntinfo['a_gametitle']; // Use the arcade gametitle if there is any.
			if ($tourmntinfo['joincost'])
			{
				$tourmntinfo['joincost_format'] = vb_number_format($tourmntinfo['joincost']);
				$tourmntinfo['prize'] = vb_number_format($tourmntinfo['joincost'] * $tourmntinfo['numplayers']);
			}
			else
			{
				$tourmntinfo['prize'] = $vbphrase['none'];
				$tourmntinfo['joincost_format'] = $vbphrase['free'];
			}
			$tourmntinfo['created_date'] = vbdate($vbulletin->options['dateformat'], $tourmntinfo['datestamp']);
			$tourmntinfo['created_time'] = vbdate($vbulletin->options['timeformat'],  $tourmntinfo['datestamp']);

			($hook = vBulletinHook::fetch_hook('arcadetourmnt_tournamentbits')) ? eval($hook) : false;

			exec_switch_bg(3);
			eval('$finishedlist .= "' . fetch_template('v3arcade_tournamentbits') . '";');
		}
	}
	else
	{
		$nonecolspan = ($vbulletin->options['tourmntEnableCosts']) ? 6 : 5;
		eval('$finishedlist .= "' . fetch_template('v3arcade_tournamentbits_none') . '";');
	}

	$db->free_result($tourmntresults);

	// Fetch navbar
	$navbits = array(
		'arcade.php' . $vbulletin->session->vars['sessionurl_q'] => $vbulletin->options['arcadename'],
		'arcadetourmnt.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tournaments'],
		'' => $vbphrase['your_tournaments']
	);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_TOURNAMENT') . '");');
}

// #############################################################################
if ($_REQUEST['do'] == 'deletetourmnt')
{
	// 'deletetourmnt'
	// Delete tournament

	// Are the user allowed to edit and delete tournaments?
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_deletetourmnt')) ? eval($hook) : false;

	$vbulletin->input->clean_array_gpc('r', array(
		'tid' => TYPE_UINT,
		'ret' => TYPE_UINT
	));

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "v3arcade_tournaments
		WHERE tid = " . $vbulletin->GPC['tid']
	);
	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers
		WHERE tid = " . $vbulletin->GPC['tid']
	);

	build_tournament_cache();

	switch($vbulletin->GPC['ret'])
	{
		case 1:
			$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewactive';
		break;
		case 2:
			$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewwaiting';
		break;
		case 3:
			$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewfinished';
		break;
		default:
			$vbulletin->url = 'arcade.php' . $vbulletin->session->vars['sessionurl_q'];
	}

	eval(print_standard_redirect('v3_tournament_deleted'));
}

// #############################################################################
if ($_REQUEST['do'] == 'fetchtitle')
{
	// 'fetchtitle'
	// Gets the title and description for ajax editing
	$vbulletin->input->clean_array_gpc('r', array(
		'tid' => TYPE_UINT,
		'ret' => TYPE_UINT
	));

	$tournament = $db->query_first("
		SELECT tid, title, description
		FROM " . TABLE_PREFIX . "v3arcade_tournaments
		WHERE tid = " . $vbulletin->GPC['tid']
	);

	if (!$tournament['tid'])
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['tournaments'])));
	}

	$ret = $vbulletin->GPC['ret'];
	eval('print_output("' . fetch_template('v3arcade_tournament_ajax_edit') . '");');
}

// ##### Save the title for ajax editing ######################################
if ($_REQUEST['do'] == 'savetourmnttitle')
{
	// Are the user allowed to edit and delete tournaments?
	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'tid' => TYPE_UINT,
		'ret' => TYPE_UINT,
		'title' => TYPE_NOHTML,
		'description' => TYPE_NOHTML
	));

	if (!$vbulletin->GPC['title'])
	{
		$vbulletin->GPC['title'] = $vbulletin->userinfo['username'] . ' ' . vbdate($vbulletin->options['dateformat'], TIMENOW);
	}

	$vbulletin->GPC['title'] = fetch_word_wrapped_string(substr($vbulletin->GPC['title'], 0, $vbulletin->options['tourmnt_maxtitle']));
	$vbulletin->GPC['description'] = fetch_word_wrapped_string(substr($vbulletin->GPC['description'], 0, $vbulletin->options['tourmnt_maxdesc']));

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_tournaments SET
			title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
			description = '" . $db->escape_string($vbulletin->GPC['description']) . "'
		WHERE tid = " . $vbulletin->GPC['tid']
	);

	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'];

	switch ($vbulletin->GPC['ret'])
	{
		case 1:
			$vbulletin->url .= 'do=viewactive';
		break;
		case 2:
			$vbulletin->url .= 'do=viewwaiting';
		break;
		case 3:
			$vbulletin->url .= 'do=viewfinished';
		break;
		default:
			$vbulletin->url .= 'do=viewyour';
	}

	eval(print_standard_redirect('v3_tournament_title_updated'));
}

// #############################################################################
if ($_REQUEST['do'] == 'clearplaying')
{
	// 'clearplaying'
	// Clear the playing flag, in case a game doesn't submit the score correctly.
	$vbulletin->input->clean_array_gpc('r', array(
		'tpid' => TYPE_UINT,
		'tid' => TYPE_UINT
	));

	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid']
	);
	if (!$tournament['tid'])
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_clearplaying')) ? eval($hook) : false;

	if (($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt'])
		OR $tournament['creator'] == $vbulletin->userinfo['userid']
	)
	{
		// It's a user with admins right (admin or creator), just clear the flag
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
				playing = 0
			WHERE tpid = " . $vbulletin->GPC['tpid'] . "
				AND tid = " . $vbulletin->GPC['tid']
		);
	}
	else
	{
		// If no admin, only update if the userid match
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
				playing = 0
			WHERE tpid = " . $vbulletin->GPC['tpid'] . "
				AND tid = " . $vbulletin->GPC['tid'] . "
				AND userid = " . $vbulletin->userinfo['userid']
		);
	}

	// Do the same check as if a result was submitted.
	$slotsresult = $db->query_read("
		SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
		WHERE round = $tournament[round]
			AND tid = " . $vbulletin->GPC['tid'] . "
		ORDER BY slot ASC
	");
	if ($slotsresult)
	{
		$slots = array();
		while ($slot = $db->fetch_array($slotsresult))
		{
			$slots[$slot['slot']] = $slot;
			if ($slot['tpid'] == $vbulletin->GPC['tpid']) $thisplayer = $slot;
		}
	}

	$db->free_result($slotsresult);

	if ($thisplayer AND $slots)
	{
		compare_slots($tournament, $thisplayer, $slots);
	}

	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];
	eval(print_standard_redirect('v3_playing_flag_cleared'));
}

// #############################################################################
if ($_REQUEST['do'] == 'cmpscores')
{
	// 'cmpscores'
	// Compare all the scores in the current round
	$vbulletin->input->clean_gpc('r', 'tid', TYPE_UINT);

	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid'] . "
			AND status < 2
	");
	if (!$tournament['tid'])
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']) AND $vbulletin->userinfo['userid'] != $tournament['creator'])
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_cmpscores')) ? eval($hook) : false;

	// Get all slots for the current round and compare all results
	compare_allscores($tournament);

	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];
	eval(print_standard_redirect('v3_scores_compared'));
}

// #############################################################################
if ($_REQUEST['do'] == 'disqualify')
{
	// 'disqualify'
	// Disqualify a player or all of them.
	$vbulletin->input->clean_array_gpc('r', array(
		'tid' => TYPE_UINT,
		'uid' => TYPE_UINT,
		'cmd' => TYPE_STR
	));

	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid'] . "
			AND status < 2
	");

	if (!$tournament['tid'])
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']) AND $vbulletin->userinfo['userid'] != $tournament['creator'])
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_disqualify')) ? eval($hook) : false;

	if ($vbulletin->GPC['cmd'] == 'all' AND !$vbulletin->GPC['uid'])
	{
		// Disqualify all players!
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
				status = 11,
				datestamp = " . TIMENOW . ",
				playing = 0
			WHERE tid = $tournament[tid]
				AND status < 9
		");
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournaments SET
				status = 2
			WHERE tid = $tournament[tid]
		");

		build_tournament_cache();

		// Send notification to all players, therefore pick the users in the first round.
		$firstround = fetch_num_rounds($tournament['numplayers']);
		if ($firstround)
		{
			$slotsresult = $db->query_read("
				SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
				FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
				WHERE round = $firstround
					AND tid = $tournament[tid]
				ORDER BY slot ASC
			");
			if ($slotsresult)
			{
				vbmail_start();
				while ($slot = $db->fetch_array($slotsresult))
				{
					if (($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['tournamentsevents']) AND $vbulletin->userinfo['userid'] != $slot['userid'])
					{
						if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
						{
							vbmail($slot['email'],
								construct_phrase($vbphrase['tournaments_notification'], $tournament[title]),
								construct_phrase($vbphrase['tournaments_notification_alldisqualified_email'], $slot['username'], $tournament[title], $vbulletin->options['bburl'] . "/arcadetourmnt.php?do=viewtourmnt&tid=" . $tournament[tid], $vbulletin->userinfo['username']),
								false
							);
						}

						if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
						{
							$senderpermissions['adminpermissions'] = 2;

							$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
							$pmdm->set_info('is_automated', true);
							$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
							$pmdm->set('fromusername', $vbulletin->userinfo['username']);
							$pmdm->set('title', construct_phrase($vbphrase['tournaments_notification'], $tournament[title]));
							$pmdm->set('message', construct_phrase(
								$vbphrase['tournaments_notification_alldisqualified_pm'],
								$slot['username'],
								$tournament['title'],
								$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
								$vbulletin->userinfo['username']
							));
							$pmdm->set_recipients($slot['username'], $senderpermissions);
							$pmdm->set('dateline', TIMENOW);

							$pmdm->save();
						}
					}
				}
				vbmail_end();
			}
		}

		$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];
		eval(print_standard_redirect('v3_all_players_disqualified'));
	}

	if (!$vbulletin->GPC['cmd'] AND isset($vbulletin->GPC['uid']))
	{
		// Disqualify the submitted user
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
				status = 11,
				datestamp = " . TIMENOW . ",
				playing = 0
			WHERE tid = $tournament[tid]
				AND status < 9
				AND userid = " . $vbulletin->GPC['uid']
		);

		// Get all slots for the current round and compare all results
		compare_allscores($tournament);

		$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];
		eval(print_standard_redirect('v3_player_disqualified'));
	}

	// If everything was correct you wouldn't be here
	print_no_permission();
}

// #############################################################################
if ($_REQUEST['do'] == 'sendreminders')
{
	// 'sendreminders'
	// Send a reminder message to players that hasn't showed any activity.
	$vbulletin->input->clean_gpc('r', 'tid', TYPE_UINT);

	$tournament = $db->query_first("
		SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
		WHERE tid = " . $vbulletin->GPC['tid'] . "
			AND status = 1
	");
	if (!$tournament)
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Use the arcade gametitle if there is any.
	if ($tournament['a_gametitle'])
	{
		$tournament['gametitle'] = $tournament['a_gametitle'];
	}

	if (!($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt']) AND $vbulletin->userinfo['userid'] != $tournament['creator'])
	{
		print_no_permission();
	}

	// Send message to all players in the current round with not enough activity
	$slotsresult = $db->query_read("
		SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
		FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
		WHERE round = $tournament[round]
			AND tid = $tournament[tid]
		ORDER BY slot ASC
	");
	if ($slotsresult)
	{
		$sendtpids = array(); // Save all id's that we send notifications to.

		vbmail_start();
		while ($slot = $db->fetch_array($slotsresult))
		{
			$reminderdate = '';
			if ($slot['tries'] < $tournament['numtries'] AND $slot['status'] < 9)
			{
				if ($slot['notified'])
				{
					$reminderdate = $slot['notified'];
				}
				else
				{
					if ($tournament['roundstart'] > $slot['datestamp'])
					{
						$reminderdate = $tournament['roundstart'];
					}
					else
					{
						$reminderdate = $slot['datestamp'];
					}
				}

				$reminderdate += $vbulletin->options['tourmntReminderTime'] * 3600;

				if (TIMENOW > $reminderdate)
				{
					($hook = vBulletinHook::fetch_hook('arcadetourmnt_sendreminder')) ? eval($hook) : false;

					// This one should get a reminder, but only if he/she has choosed to get event messages though...
					if (($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['tournamentsevents']) AND $vbulletin->userinfo['userid'] != $slot['userid'])
					{
						if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
						{
							vbmail($slot['email'],
								construct_phrase($vbphrase['tournaments_notification'], $tournament['title']),
								construct_phrase(
									$vbphrase['tournaments_notification_reminder_email'],
									$slot['username'],
									$tournament['title'],
									$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
									$vbulletin->userinfo['username']
								),
								false
							);

							$sendtpids[$slot['tpid']] = $slot['tpid'];
						}

						if ($slot['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
						{
							$senderpermissions['adminpermissions'] = 2;

							$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
							$pmdm->set_info('is_automated', true);
							$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
							$pmdm->set('fromusername', $vbulletin->userinfo['username']);
							$pmdm->set('title', construct_phrase($vbphrase['tournaments_notification'], $tournament[title]));
							$pmdm->set('message', construct_phrase(
								$vbphrase['tournaments_notification_reminder_pm'],
								$slot['username'],
								$tournament['title'],
								$vbulletin->options['bburl'] . '/arcadetourmnt.php?do=viewtourmnt&tid=' . $tournament['tid'],
								$vbulletin->userinfo['username']
							));
							$pmdm->set_recipients($slot['username'], $senderpermissions);
							$pmdm->set('dateline', TIMENOW);

							if (empty($pmdm->errors)) $pmdm->save();

							$sendtpids[$slot['tpid']] = $slot['tpid'];
						}
					}
				}
			}
		}
		vbmail_end();

		$nummsg = count($sendtpids);

		if (!empty($sendtpids))
		{
			// Update database with the date of this notification
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
					notified = " . TIMENOW . "
				WHERE tpid IN (" . implode(', ', $sendtpids) . ")
			");
		}
	}

	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];
	eval(print_standard_redirect('v3_reminder_message_sent'));
}

// #############################################################################
if ($_REQUEST['do'] == 'withdraw')
{
	// 'withdraw'
	// Withdraws a player from the tournament. Only if it hasn't started yet.
	$vbulletin->input->clean_array_gpc('r', array(
		'uid' => TYPE_UINT,
		'tid' => TYPE_UINT
	));

	$tournament = $db->query_first("
		SELECT arcade_tournaments.*
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
		WHERE tid = " . $vbulletin->GPC['tid']
	);
	if (!$tournament['tid'])
	{
		eval(standard_error($vbphrase['v3_no_tournament_found']));
	}

	// Check if it is possible to withdraw. Tournament not started, user is not the same or hasn't got the rights
	if ($tournament['status']
		OR ($vbulletin->GPC['uid'] != $vbulletin->userinfo['userid']
			AND !($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canadmintourmnt'])
			AND $vbulletin->userinfo['userid'] != $tournament['creator']
		)
	)
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcadetourmnt_withdraw')) ? eval($hook) : false;

	// Remove player, reset the slot to userid 0
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
			status = 0,
			userid = 0
		WHERE tid = $tournament[tid]
			AND userid = " . $vbulletin->GPC['uid']
	);

	if ($db->affected_rows())
	{
		// Create a new slot (status = 40) for the user so we know that he/she has already joined once
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "v3arcade_tournamentplayers
				(tid, userid, datestamp, status, round)
			VALUES (
				$tournament[tid],
				" . $vbulletin->GPC['uid'] . ",
				" . TIMENOW . ",
				40,
				99
		)");

		// Update tournament info
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournaments SET
				openslots = openslots+1
			WHERE tid = " . $vbulletin->GPC['tid']
		);
	}
	else
	{
		eval(standard_error(fetch_error('v3_withdraw_failed')));
	}

	$vbulletin->url = 'arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&tid=' . $vbulletin->GPC['tid'];

	eval(print_standard_redirect('v3_player_withdrawn'));
}

// ##### Send Tournament Invite ###############################################
if ($_POST['do'] == 'tourinvite')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tid' => TYPE_UINT,
		'userid' => TYPE_UINT
	));

	if (!$game = $db->query_first("
		SELECT tournaments.tid, games.*
		FROM " . TABLE_PREFIX . "v3arcade_tournaments AS tournaments
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (tournaments.gameid = games.gameid)
		WHERE tournaments.tid = " . $vbulletin->GPC['tid']
	))
	{
		eval(standard_error(fetch_error('v3_please_select_tournament')));
	}

	$tid =& $vbulletin->GPC['tid'];
	send_tournament_invite($vbulletin->GPC['userid']);

	$vbulletin->url = 'member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $vbulletin->GPC['userid'] . '&tab=v3arcade_stats';
	eval(print_standard_redirect('v3_tournament_invite_sent'));
}


?>